import { createEvent, sample } from 'effector';

import { createDialogApi } from '@client/shared/libs/effector-helpers/dialog';

import { ActivationCode, Email } from '../types';
import * as addModel from './add-recovery-email';
import * as confirmByCodeModel from './confirm-recovery-email-by-code';
import * as confirmByQueryModel from './confirm-recovery-email-by-query';
import * as removeModel from './remove-recovery-email';

interface ActionDialogState {
  email: Email;
  isConfirmed: boolean;
}

export const dialog = createDialogApi<ActionDialogState>();

export const addEmailClicked = createEvent();
export const confirmClicked = createEvent<Email>();
export const removeEmailClicked = createEvent<Email>();
export const activationQueryMounted = createEvent<ActivationCode>();

sample({
  clock: addEmailClicked,
  target: addModel.dialog.show,
});

sample({
  clock: addModel.addRecoveryEmailFx.doneData,
  source: addModel.form.fields.email.$value,
  fn: (email, trackId) => ({ email, trackId }),
  target: [addModel.dialog.hide, confirmByCodeModel.dialog.show],
});

sample({
  clock: confirmClicked.map((email) => ({ email })),
  target: [dialog.hide, confirmByCodeModel.dialog.show],
});

sample({
  clock: activationQueryMounted,
  target: confirmByQueryModel.activated,
});

sample({
  clock: removeEmailClicked.map((email) => ({ email })),
  target: [dialog.hide, removeModel.dialog.show],
});
