import { attach, createEvent, sample } from 'effector';

import { ConfirmByPasswordModel } from '@client/features/confirm-by-password';
import { createDialogApi } from '@client/shared/libs/effector-helpers/dialog';

import * as api from '../api';
import { notifications } from '../libs/notifier';
import type { Email } from '../types';

interface DialogState {
  email: Email;
}

export const dialog = createDialogApi<DialogState>();

export const confirmClicked = createEvent();

export const removeRecoverEmailFx = attach({
  effect: api.removeRecoveryEmailFx,
  source: {
    email: dialog.$state.map((state) => state.email),
    trackId: ConfirmByPasswordModel.form.fields.trackId.$value,
  },
  mapParams: (_, payload) => payload,
});

removeRecoverEmailFx.failData.watch((payload) => {
  switch (payload.reason) {
    case api.RemoveRecoveryEmailProblemKind.PasswordRequired:
      ConfirmByPasswordModel.dialog.show({ trackId: payload.trackId });
      break;
    case api.RemoveRecoveryEmailProblemKind.Internal:
      notifications.internalError();
      break;
  }
});

export const $isRemoveEmailPending = removeRecoverEmailFx.pending;

sample({
  clock: confirmClicked,
  target: removeRecoverEmailFx,
});

sample({
  clock: removeRecoverEmailFx.done,
  target: [dialog.hide, dialog.reset, notifications.removedSuccessful],
});

sample({
  clock: ConfirmByPasswordModel.confirmFx.done,
  filter: dialog.$isVisible,
  target: removeRecoverEmailFx,
});
