/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent, useStore } from 'effector-react';
import { VFC, useCallback } from 'react';

import { MailOutline } from '@client/shared/icons';
import { TrashOutline } from '@client/shared/icons';
import { Button, CardTemplate, Dialog, Hint, List, ListItem, Text } from '@client/shared/ui-kit';

import * as model from '../../models/flow';

import styles from './ActionsDialog.module.css';

export const ActionsDialog: VFC = () => {
  const isVisible = useStore(model.dialog.$isVisible);
  const state = useStore(model.dialog.$state);

  const onHide = useEvent(model.dialog.hide);
  const onReset = useEvent(model.dialog.reset);

  const onConfirmPress = useCallback(() => {
    model.confirmClicked(state.email);
  }, [state]);

  const onRemovePress = useCallback(() => {
    model.removeEmailClicked(state.email);
  }, [state]);

  return (
    <Dialog visible={isVisible} onClose={onHide} onCloseEnd={onReset}>
      <div className={styles.content}>
        <CardTemplate className={styles.card}>
          <CardTemplate.Content className={styles.heading}>
            <Text variant="text-m-long">Почта для восстановления</Text>
            <Text
              variant="heading-l"
              weight="bold"
              color={state.isConfirmed ? 'primary' : 'secondary'}
            >
              {state.email}
            </Text>
          </CardTemplate.Content>

          {!state.isConfirmed && (
            <Hint text="Чтобы подтвердить почту, откройте письмо от Яндекс ID" />
          )}

          <List>
            {!state.isConfirmed && (
              <ListItem
                tabIndex={0}
                icon={<MailOutline />}
                text="Подтвердить почту"
                onPress={onConfirmPress}
              />
            )}
            <ListItem tabIndex={0} icon={<TrashOutline />} text="Удалить" onPress={onRemovePress} />
          </List>

          <CardTemplate.Actions>
            <Button size="xl" variant="default" onPress={onHide}>
              Закрыть
            </Button>
          </CardTemplate.Actions>
        </CardTemplate>
      </div>
    </Dialog>
  );
};
