/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent, useStore } from 'effector-react';
import { VFC } from 'react';

import mailBlueSource from '@client/shared/assets/mail-blue.png';
import { useForm } from '@client/shared/libs/effector-forms';
import { Button, Form, ImageIcon, Modal, Section, TextField } from '@client/shared/ui-kit';

import * as model from '../../models/add-recovery-email';

import styles from './AddRecoveryEmailDialog.module.css';

export const AddRecoveryEmailDialog: VFC = () => {
  const { submit, fields } = useForm(model.form);

  const isVisible = useStore(model.dialog.$isVisible);
  const isAddEmailPending = useStore(model.$isAddEmailPending);

  const onHide = useEvent(model.dialog.hide);
  const onSubmit = useEvent(submit);

  return (
    <Modal visible={isVisible} onClose={onHide} keepMounted={false} className={styles.modal}>
      <Form onSubmit={onSubmit} className={styles.content}>
        <Section className={styles.section}>
          <Section.Media>
            <ImageIcon src={mailBlueSource} size={96} />
          </Section.Media>

          <Section.Title isHeading>Email для восстановления</Section.Title>

          <Section.Description>
            Введите email, который поможет восстановить доступ к аккаунту
          </Section.Description>

          <TextField
            type="email"
            autoFocus={isVisible}
            error={fields.email.errorText({
              confirmed: 'Этот email уже подтверждён',
              email: 'Не удалось отправить письмо, проверьте что email написан без ошибок',
              native: 'Укажите email, отличный от вашего логина в Яндексе',
              required: 'Введите email',
            })}
            onChangeValue={fields.email.onChange}
            placeholder="Введите email"
            size="xl"
            value={fields.email.value}
          />

          <Button size="xl" variant="action" onPress={onSubmit} disabled={isAddEmailPending}>
            {isAddEmailPending ? 'Выполняется...' : 'Готово'}
          </Button>
        </Section>
      </Form>
    </Modal>
  );
};
