/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent, useStore } from 'effector-react';
import { VFC } from 'react';

import { Sync } from '@client/shared/icons';
import { useForm } from '@client/shared/libs/effector-forms';
import { CodeField, Form, Modal, Section, Spinner, Text, TextButton } from '@client/shared/ui-kit';

import * as model from '../../models/confirm-recovery-email-by-code';

import styles from './CodeConfirmationDialog.module.css';

export const CodeConfirmationDialog: VFC = () => {
  const { fields, submit } = useForm(model.form);

  const isConfirmPending = useStore(model.$isConfirmPending);
  const isResendPending = useStore(model.$isResendPending);
  const state = useStore(model.dialog.$state);

  const onSubmit = useEvent(submit);
  const onResendCode = useEvent(model.codeResendClicked);

  const isVisible = useStore(model.dialog.$isVisible);
  const onHide = useEvent(model.dialog.hide);

  return (
    <Modal visible={isVisible} onClose={onHide} keepMounted={false} className={styles.modal}>
      <Form className={styles.content}>
        <Section className={styles.section}>
          <Section.Title isHeading>Введите код из письма</Section.Title>

          <Section.Description>
            Код отправлен на адрес <Text weight="bold">{state?.email}</Text>. Чтобы не вводить код,
            можно перейти по ссылке в письме
          </Section.Description>

          <CodeField
            autoFocus={isVisible}
            codeLength={6}
            inputMode="numeric"
            value={fields.code.value}
            onChange={fields.code.onChange}
            onComplete={onSubmit}
            invalid={fields.code.hasError()}
            disabled={isConfirmPending}
          />

          <TextButton
            before={isResendPending ? <Spinner size={24} /> : <Sync />}
            disabled={isConfirmPending || isResendPending}
            onPress={onResendCode}
            size="xl"
            className={styles.button}
          >
            Выслать код повторно
          </TextButton>
        </Section>
      </Form>
    </Modal>
  );
};
