/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent } from 'effector-react';
import { VFC, useEffect } from 'react';

import { MailOutline } from '@client/shared/icons';
import { logProps } from '@client/shared/libs/metrika';
import { useQueryParams } from '@client/shared/libs/router';
import { List, ListItemAction } from '@client/shared/ui-kit';

import { useRecoveryEmails } from '../../api';
import * as model from '../../models/flow';
import { ActionsDialog } from '../ActionsDialog/ActionsDialog';
import { AddRecoveryEmailDialog } from '../AddRecoveryEmailDialog/AddRecoveryEmailDialog';
import { CodeConfirmationDialog } from '../CodeConfirmationDialog/CodeConfirmationDialog';
import { RemoveConfirmationDialog } from '../RemoveConfirmationDialog/RemoveConfirmationDialog';
import { RecoveryEmailListItem } from './RecoveryEmailListItem';

interface QueryParams {
  code: string;
  action: string;
}

interface RecoveryEmailListProps {
  showAddEmail?: boolean;
}

export const RecoveryEmailList: VFC<RecoveryEmailListProps> = (props) => {
  const { showAddEmail } = props;

  const query = useQueryParams<QueryParams>();
  const { data: emails } = useRecoveryEmails();

  const onAddEmail = useEvent(model.addEmailClicked);

  useEffect(() => {
    if (query.action === 'activate-recovery-email' && query.code) {
      model.activationQueryMounted(query.code);
    }
  }, [query.action, query.code]);

  return (
    <>
      <List>
        {emails?.map((email) => (
          <RecoveryEmailListItem
            email={email.address}
            isConfirmed={email.isConfirmed}
            key={email.address}
          />
        ))}

        {showAddEmail && (
          <ListItemAction
            type="add"
            {...logProps('listitem.add-email')}
            icon={<MailOutline />}
            tabIndex={0}
            text="Добавить запасную почту"
            onPress={onAddEmail}
          />
        )}
      </List>

      <ActionsDialog />
      <AddRecoveryEmailDialog />
      <CodeConfirmationDialog />
      <RemoveConfirmationDialog />
    </>
  );
};
