/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { VFC, useCallback } from 'react';

import { MailOutline } from '@client/shared/icons';
import { logProps } from '@client/shared/libs/metrika';
import { ListItemAction } from '@client/shared/ui-kit';

import * as model from '../../models/flow';

interface EmailListItemProps {
  email: string;
  isConfirmed: boolean;
}

export const RecoveryEmailListItem: VFC<EmailListItemProps> = (props) => {
  const { email, isConfirmed } = props;

  const onShowDialog = useCallback(() => {
    model.dialog.show({ email, isConfirmed });
  }, [email, isConfirmed]);

  return (
    <ListItemAction
      type="kebab"
      {...logProps('listitem.email')}
      icon={<MailOutline />}
      label="Запасная почта"
      tabIndex={0}
      text={email}
      warning={!isConfirmed && 'не подтверждена'}
      onPress={onShowDialog}
    />
  );
};
