/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useEvent, useStore } from 'effector-react';
import { VFC } from 'react';

import crossFieldSource from '@client/shared/assets/cross-filled.png';
import { Button, CardTemplate, Dialog, ImageIcon, Text } from '@client/shared/ui-kit';

import * as model from '../../models/remove-recovery-email';

import styles from './RemoveConfirmationDialog.module.css';

export const RemoveConfirmationDialog: VFC = () => {
  const isVisible = useStore(model.dialog.$isVisible);
  const isRemoveEmailPending = useStore(model.$isRemoveEmailPending);

  const onHide = useEvent(model.dialog.hide);
  const onConfirm = useEvent(model.confirmClicked);

  return (
    <Dialog visible={isVisible} onClose={onHide} keepMounted={false} className={styles.modal}>
      <div className={styles.content}>
        <CardTemplate>
          <CardTemplate.Media>
            <ImageIcon src={crossFieldSource} size={120} />
          </CardTemplate.Media>

          <CardTemplate.Content align="center">
            <Text variant="heading-l" weight="bold">
              Точно удалить?
            </Text>
            <Text variant="text-m-long">
              Спрашиваем на всякий случай — ведь почта удалится навсегда
            </Text>
          </CardTemplate.Content>

          <CardTemplate.Actions>
            <Button size="xl" variant="default" disabled={isRemoveEmailPending} onPress={onConfirm}>
              {isRemoveEmailPending ? 'Выполняется...' : 'Удалить'}
            </Button>

            <Button size="xl" variant="clear" onPress={onHide}>
              Оставить всё как есть
            </Button>
          </CardTemplate.Actions>
        </CardTemplate>
      </div>
    </Dialog>
  );
};
