import { createEffect } from 'effector';

import type { AddressDetailsFragment as Address } from '@client/shared/api/graphql';
import {
  CreateOrUpdateAddressDocument,
  CreateOrUpdateAddressInput,
  CreateOrUpdateAddressMutation,
  CreateOrUpdateAddressProblem,
  DeleteAddressDocument,
  DeleteAddressMutation,
} from '@client/shared/api/graphql';
import { getOrCreateClient } from '@client/shared/libs/apollo';
import { DeleteAddressInput, DeleteAddressProblem } from '@server/graphql-schema';

export { AddressType } from '@client/shared/api/graphql';
export type { AddressDetailsFragment as Address } from '@client/shared/api/graphql';

export type AddressId = Address['id'];

export const createOrUpdateAddressFx = createEffect<
  CreateOrUpdateAddressInput,
  boolean,
  CreateOrUpdateAddressProblem
>(async (input) => {
  const apollo = getOrCreateClient({});

  const { data } = await apollo.mutate<CreateOrUpdateAddressMutation>({
    mutation: CreateOrUpdateAddressDocument,
    variables: { input },
  });

  if (data?.response.__typename === 'CreateOrUpdateAddressProblem') {
    return Promise.reject(data.response);
  }

  return true;
});

export const deleteAddressFx = createEffect<DeleteAddressInput, boolean, DeleteAddressProblem>(
  async (input) => {
    const apollo = getOrCreateClient({});

    const { data } = await apollo.mutate<DeleteAddressMutation>({
      mutation: DeleteAddressDocument,
      variables: { input },
    });

    if (data?.response.__typename === 'DeleteAddressProblem') {
      return Promise.reject(data.response);
    }

    return true;
  },
);
