import { attach, sample, split } from 'effector';

import * as api from '../api';
import { form } from './form';
import { notifications } from './notifier';

export const createOrUpdateAddressFx = attach({
  effect: api.createOrUpdateAddressFx,
  source: form.$values,
  mapParams: (_, payload) => ({
    id: payload.id,
    comment: payload.comment,
    entrance: payload.entrance,
    floor: payload.floor,
    fullText: payload.fullText,
    intercom: payload.intercom,
    room: payload.room,
    type: payload.type,
  }),
});

export const $isCreatePending = createOrUpdateAddressFx.pending;

sample({
  clock: form.formValidated,
  target: createOrUpdateAddressFx,
});

split({
  source: createOrUpdateAddressFx.failData,
  match: (payload) => payload.reason,
  cases: {
    __: notifications.internalError,
  },
});

split({
  clock: createOrUpdateAddressFx.done,
  source: form.$values,
  match: {
    created: (form) => Boolean(!form.id),
    updated: (form) => Boolean(form.id),
  },
  cases: {
    created: notifications.createdSuccessful,
    updated: notifications.updatedSuccessful,
  },
});
