import { attach, createEvent, sample, split } from 'effector';

import * as api from '../api';
import { deleteConfirmationModel } from './confirmation';
import { form } from './form';
import { notifications } from './notifier';

export const deletePressed = createEvent();

export const deleteAddressFx = attach({
  effect: api.deleteAddressFx,
  source: form.$values,
  mapParams: (_, payload) => ({ id: payload.id }),
});

export const $isDeletePending = deleteAddressFx.pending;

sample({
  clock: deletePressed,
  target: deleteConfirmationModel.confirm,
});

sample({
  clock: deleteConfirmationModel.confirmed,
  target: deleteAddressFx,
});

split({
  source: deleteAddressFx.failData,
  match: (payload) => payload.reason,
  cases: {
    __: notifications.internalError,
  },
});

sample({
  clock: deleteAddressFx.done,
  target: notifications.deletedSuccessful,
});
