import { createEvent, sample, split } from 'effector';

import { createDialogApi } from '@client/shared/libs/effector-helpers';

import type { Address } from '../api';
import { closeConfirmationModel } from './confirmation';
import { createOrUpdateAddressFx } from './create-or-update-address';
import { deleteAddressFx } from './delete-address';
import { form } from './form';

export const dialog = createDialogApi();

export const addressPressed = createEvent<Address>();
export const closePressed = createEvent();

sample({
  clock: addressPressed,
  target: [form.set, dialog.show],
});

split({
  clock: closePressed,
  source: form.$isTouched,
  match: {
    close: (isTouched) => !isTouched,
    confirm: (isTouched) => isTouched,
  },
  cases: {
    close: dialog.hide,
    confirm: closeConfirmationModel.confirm,
  },
});

sample({
  clock: closeConfirmationModel.confirmed,
  target: dialog.hide,
});

sample({
  clock: [createOrUpdateAddressFx.done, deleteAddressFx.done],
  target: dialog.hide,
});

sample({
  clock: dialog.hide,
  target: form.reset,
});
