import { VFC, useRef } from 'react';

import { Business, Home, LocationOutline, Pencil } from '@client/shared/icons';
import { ListItemView, Text } from '@client/shared/ui-kit';
import { useFocusable } from '@use-platform/react';

import { AddressType } from '../../api';

import styles from './AddressPlate.module.css';

interface AddressPlateProps {
  onPress: () => void;
  region: string;
  text: string;
  type: AddressType;
  autoFocus?: boolean;
}

export const AddressPlate: VFC<AddressPlateProps> = (props) => {
  const { onPress, region, text, type } = props;

  const IconType = getIconType(type);

  const ref = useRef<HTMLDivElement>(null);

  useFocusable(props, ref);

  return (
    <ListItemView className={styles.root} onPress={onPress} ref={ref} role="button" tabIndex={0}>
      <ListItemView.Before>
        <IconType size={24} />
      </ListItemView.Before>

      <ListItemView.Content className={styles.content}>
        <Text color="primary" maxLines={3} overflow="ellipsis" variant="text-m">
          {text}
        </Text>
        <Text color="secondary" maxLines={3} overflow="ellipsis" variant="text-s">
          {region}
        </Text>
      </ListItemView.Content>

      <ListItemView.After>
        <Pencil className={styles.edit} size={24} />
      </ListItemView.After>
    </ListItemView>
  );
};

function getIconType(type: AddressType) {
  return {
    [AddressType.Home]: Home,
    [AddressType.Work]: Business,
    [AddressType.Other]: LocationOutline,
  }[type];
}
