import { WHITE_LIST_QUERY_PARAMS } from '../constants';

export function getQueryParams() {
  // location.hash не пустой, и при этом он не равен решетке с подчеркиваниями, тогда берем его
  // location.hash !== '#_=_'
  // грязный хак для Facebook
  const search = location.hash && location.hash !== '#_=_' ? location.hash : location.search;
  const params = search.substring(1).split('&');

  const result: Record<string, string> = {};

  for (const param of params) {
    const [k, v] = param.split('=');
    const key = decodeURIComponent(k);
    const value = decodeURIComponent(v);

    if (WHITE_LIST_QUERY_PARAMS.includes(key) && value.length < 40) {
      result[key] = value;
    }
  }

  return result;
}
