export function getWindowProperties() {
  const width = 650;
  const height = 370;
  const left = Math.round(((window.opera ? window.innerWidth : screen.availWidth) - width) / 2);
  const top = Math.round(((window.opera ? window.innerHeight : screen.availHeight) - height) / 2);

  const properties = [
    'scrollbars=yes',
    'resizable=1',
    'menubar=0',
    'toolbar=0',
    'status=0',
    'location=0',
    'directories=0',
    `left=${left}`,
    `top=${top}`,
    `width=${width}`,
    `height=${height}`,
  ];

  return properties.join(', ');
}
