export interface WindowUrlOptions {
  url: string;
  popupName?: string;
  retpath?: string;
}

export function getWindowUrl(provider: string, options: WindowUrlOptions) {
  const { url, popupName, retpath } = options;
  const urlObj = new URL(url);

  urlObj.searchParams.set('provider', provider);
  urlObj.searchParams.set('display', 'popup');
  urlObj.searchParams.set('place', 'fragment');
  urlObj.searchParams.set('consumer', 'passport');
  urlObj.searchParams.set('resize', '1');
  urlObj.searchParams.set('require_auth', '1');

  if (popupName) {
    urlObj.searchParams.set('popupName', popupName);
  }

  if (retpath) {
    urlObj.searchParams.set('retpath', retpath);
  }

  return urlObj;
}
