import { useEvent, useStore } from 'effector-react';
import { useCallback, useRef } from 'react';

import lockSrc from '@client/shared/assets/lock.png';
import { useForm } from '@client/shared/libs/effector-forms';
import {
  Button,
  CardTemplate,
  Form,
  ImageIcon,
  Modal,
  PasswordField,
  Text,
} from '@client/shared/ui-kit';
import { focusWithoutScrolling } from '@use-platform/react/libs/dom-utils';

import { i18n } from './i18n';
import * as model from './model';

import styles from './ConfirmByPasswordModal.module.css';

export const ConfirmByPasswordModal = () => {
  const { fields, submit } = useForm(model.form);

  const isVisible = useStore(model.dialog.$isVisible);
  const isConfirmPending = useStore(model.$isConfirmPending);

  const onHide = useEvent(model.dialog.hide);

  const inputRef = useRef<HTMLInputElement>(null);

  const handleOnSubmit = useCallback(() => {
    submit();

    if (inputRef.current) {
      focusWithoutScrolling(inputRef.current);
    }
  }, [submit]);

  return (
    <Modal visible={isVisible} onClose={onHide} keepMounted={false}>
      <Form onSubmit={handleOnSubmit} className={styles.form}>
        <CardTemplate>
          <CardTemplate.Media>
            <ImageIcon src={lockSrc} size={96} />
          </CardTemplate.Media>

          <CardTemplate.Content align="center">
            <Text variant="heading-m" weight="bold">
              {i18n('Введите пароль от аккаунта')}
            </Text>
          </CardTemplate.Content>

          <PasswordField
            autoFocus={isVisible}
            error={fields.password.errorText({
              required: i18n('Введите пароль'),
              invalid: i18n('Неверный пароль'),
            })}
            inputRef={inputRef}
            onChangeValue={fields.password.onChange}
            placeholder={i18n('Введите пароль')}
            value={fields.password.value}
          />

          <CardTemplate.Actions>
            <Button disabled={isConfirmPending} onPress={handleOnSubmit} size="xl" variant="action">
              {i18n('Готово')}
            </Button>
          </CardTemplate.Actions>
        </CardTemplate>
      </Form>
    </Modal>
  );
};
