import { createEffect } from 'effector';

import {
  ConfirmByPasswordDocument,
  ConfirmByPasswordInput,
  ConfirmByPasswordMutation,
  ConfirmByPasswordMutationVariables,
  ConfirmByPasswordProblem,
} from '@client/shared/api/graphql';
import { getOrCreateClient } from '@client/shared/libs/apollo';

export const confirmByPasswordFx = createEffect<
  ConfirmByPasswordInput,
  boolean,
  ConfirmByPasswordProblem
>(async (input) => {
  const apollo = getOrCreateClient({});

  const result = await apollo.mutate<ConfirmByPasswordMutation, ConfirmByPasswordMutationVariables>(
    {
      mutation: ConfirmByPasswordDocument,
      variables: { input },
    },
  );

  // TODO: Нужно ли как-то дополнительно обрабатывать этот сценарий?
  if (!result.data) {
    return false;
  }

  if (result.data.confirmByPassword.__typename === 'ConfirmByPasswordProblem') {
    return Promise.reject(result.data.confirmByPassword);
  }

  return result.data.confirmByPassword.successful;
});
