import { attach, sample } from 'effector';

import { ConfirmByPasswordProblemKind } from '@client/shared/api/graphql';
import { createForm, rules } from '@client/shared/libs/effector-forms';
import { createDialogApi } from '@client/shared/libs/effector-helpers/dialog';

import * as api from './api';
import { notifications } from './libs/notifier';

interface DialogState {
  trackId: string;
}

export const dialog = createDialogApi<DialogState>();

export const form = createForm({
  fields: {
    password: {
      init: '',
      rules: [rules.required()],
    },
    trackId: {
      init: '',
      units: {
        $value: dialog.$state.map((state) => state.trackId),
      },
    },
  },
  units: {
    reset: dialog.hide,
  },
});

export const confirmFx = attach({
  effect: api.confirmByPasswordFx,
});

export const $isConfirmPending = confirmFx.pending;

confirmFx.failData.watch((payload) => {
  switch (payload.reason) {
    case ConfirmByPasswordProblemKind.PasswordNotMatched:
      form.fields.password.addError({ rule: 'invalid' });
      break;
    case ConfirmByPasswordProblemKind.Internal:
      notifications.internalError();
  }
});

sample({
  clock: form.formValidated,
  target: confirmFx,
});

sample({
  clock: confirmFx.done,
  target: dialog.hide,
});
