import { VFC } from 'react';

import { BirthCertificateForm, BirthCertificateViewer } from './ui/document-birth-certificate';
import { DriverLicenseForm, DriverLicenseViewer } from './ui/document-driver-license';
import { InnForm, InnViewer } from './ui/document-inn';
import { InternationalIdForm, InternationalIdViewer } from './ui/document-international-id';
import { MedicalInsuranceForm, MedicalInsuranceViewer } from './ui/document-medical-insurance';
import { NationalIdForm, NationalIdViewer } from './ui/document-national-id';
import { SnilsForm, SnilsViewer } from './ui/document-snils';
import {
  VehicleRegistrationCertificateForm,
  VehicleRegistrationCertificateViewer,
} from './ui/document-vehicle-registration-certificate';
import {
  VoluntaryMedicalInsuranceForm,
  VoluntaryMedicalInsuranceViewer,
} from './ui/document-voluntary-medical-insurance';

export const DocumentEditor: VFC = () => {
  return (
    <>
      <BirthCertificateForm />
      <BirthCertificateViewer />
      <DriverLicenseForm />
      <DriverLicenseViewer />
      <InnForm />
      <InnViewer />
      <NationalIdForm />
      <NationalIdViewer />
      <MedicalInsuranceForm />
      <MedicalInsuranceViewer />
      <InternationalIdForm />
      <InternationalIdViewer />
      <SnilsForm />
      <SnilsViewer />
      <VoluntaryMedicalInsuranceForm />
      <VoluntaryMedicalInsuranceViewer />
      <VehicleRegistrationCertificateForm />
      <VehicleRegistrationCertificateViewer />
    </>
  );
};
