import { DocumentType } from '@client/shared/api/graphql';
import {
  BabyOutlineIcon,
  CarOutlineIcon,
  DmsOutlineIcon,
  DocumentHorizontalLeftIcon,
  DocumentVerticalTopIcon,
  DriverLicenseIcon,
  MedicineIcon,
  PassportIcon,
  PlaneIcon,
} from '@client/shared/icons';

import { openDialog } from '../model/root';

export const BaseDocumentList = {
  [DocumentType.NationalId]: {
    key: DocumentType.NationalId,
    icon: <PassportIcon />,
    text: 'Паспорт РФ',
    onPress: () => {
      openDialog(DocumentType.NationalId, {});
    },
  },
  [DocumentType.DriverLicense]: {
    key: DocumentType.DriverLicense,
    icon: <DriverLicenseIcon />,
    text: 'ВУ',
    onPress: () => {
      openDialog(DocumentType.DriverLicense, {});
    },
  },
  [DocumentType.Inn]: {
    key: DocumentType.Inn,
    icon: <DocumentVerticalTopIcon />,
    text: 'ИНН',
    onPress: () => {
      openDialog(DocumentType.Inn, {});
    },
  },
  [DocumentType.Snils]: {
    key: DocumentType.Snils,
    icon: <DocumentHorizontalLeftIcon />,
    text: 'СНИЛС',
    onPress: () => {
      openDialog(DocumentType.Snils, {});
    },
  },
  [DocumentType.MedicalInsurance]: {
    key: DocumentType.MedicalInsurance,
    icon: <MedicineIcon />,
    text: 'ОМС',
    onPress: () => {
      openDialog(DocumentType.MedicalInsurance, {});
    },
  },
  [DocumentType.VoluntaryMedicalInsurance]: {
    key: DocumentType.VoluntaryMedicalInsurance,
    icon: <DmsOutlineIcon />,
    text: 'ДМС',
    onPress: () => {
      openDialog(DocumentType.VoluntaryMedicalInsurance, {});
    },
  },
  [DocumentType.InternationalId]: {
    key: DocumentType.InternationalId,
    icon: <PlaneIcon />,
    text: 'Загранпаспорт',
    onPress: () => {
      openDialog(DocumentType.InternationalId, {});
    },
  },
  [DocumentType.BirthCertificate]: {
    key: DocumentType.BirthCertificate,
    icon: <BabyOutlineIcon />,
    text: 'Св-во о рождении',
    onPress: () => {
      openDialog(DocumentType.BirthCertificate, {});
    },
  },
  [DocumentType.VehicleRegistrationCertificate]: {
    key: DocumentType.VehicleRegistrationCertificate,
    icon: <CarOutlineIcon />,
    text: 'СТС / СРТС',
    onPress: () => {
      openDialog(DocumentType.VehicleRegistrationCertificate, {});
    },
  },
};
