// Форматирует дату в ГГГГ-ММ-ДД
export function formatDateToISO(val: Date | null) {
  return val
    ? [
        String(val.getFullYear()).padStart(4, '0'),
        String(val.getMonth() + 1).padStart(2, '0'),
        String(val.getDate()).padStart(2, '0'),
      ].join('-')
    : null;
}

// Форматирует дату в ДД.ММ.ГГГГ с 'ГГГГ-ММ-ДД'
export function formatDateToNormal(date: string | undefined) {
  if (date) {
    const [year, month, day] = date.split('-');

    return `${day}.${month}.${year}`;
  }

  return '';
}
