export interface GetFullNameParams {
  firstName?: string | null;
  lastName?: string | null;
  middleName?: string | null;
  withPatronymic?: boolean;
}

export function getFullName(params: GetFullNameParams) {
  const fullName = [];

  if (params.lastName) {
    fullName.push(params.lastName);
  }
  if (params.firstName) {
    fullName.push(params.firstName);
  }
  if (params.withPatronymic && params.middleName) {
    fullName.push(params.middleName);
  }

  return fullName.join(' ');
}

export function splitFullName(fullName: string) {
  // очищаяем все не нужные пробелы, чтобы сплитануть
  const string = fullName.trim().replace(/\s+/g, ' ');

  const [lastName = '', firstName = '', middleName = ''] = string.split(' ');

  return {
    lastName,
    firstName,
    middleName,
  };
}
