import { DocumentType } from '@client/shared/api/graphql';

import { BirthCertificateFormModel } from '../ui/document-birth-certificate';
import { DriverLicenseFormModel } from '../ui/document-driver-license';
import { InnFormModel } from '../ui/document-inn';
import { InternationalIdFormModel } from '../ui/document-international-id';
import { MedicalInsuranceFormModel } from '../ui/document-medical-insurance';
import { NationalIdFormModel } from '../ui/document-national-id';
import { SnilsFormModel } from '../ui/document-snils';
import { VehicleRegistrationCertificateFormModel } from '../ui/document-vehicle-registration-certificate';
import { VoluntaryMedicalInsuranceFormModel } from '../ui/document-voluntary-medical-insurance';

export function openDialog(type: DocumentType, params?: any) {
  switch (type) {
    case DocumentType.BirthCertificate:
      BirthCertificateFormModel.dialog.setParams(params);
      BirthCertificateFormModel.dialog.show();
      break;
    case DocumentType.DriverLicense:
      DriverLicenseFormModel.dialog.setParams(params);
      DriverLicenseFormModel.dialog.show();
      break;
    case DocumentType.Inn:
      InnFormModel.dialog.setParams(params);
      InnFormModel.dialog.show();
      break;
    case DocumentType.InternationalId:
      InternationalIdFormModel.dialog.setParams(params);
      InternationalIdFormModel.dialog.show();
      break;
    case DocumentType.MedicalInsurance:
      MedicalInsuranceFormModel.dialog.setParams(params);
      MedicalInsuranceFormModel.dialog.show();
      break;
    case DocumentType.NationalId:
      NationalIdFormModel.dialog.setParams(params);
      NationalIdFormModel.dialog.show();
      break;
    case DocumentType.Snils:
      SnilsFormModel.dialog.setParams(params);
      SnilsFormModel.dialog.show();
      break;
    case DocumentType.VehicleRegistrationCertificate:
      VehicleRegistrationCertificateFormModel.dialog.setParams(params);
      VehicleRegistrationCertificateFormModel.dialog.show();
      break;
    case DocumentType.VoluntaryMedicalInsurance:
      VoluntaryMedicalInsuranceFormModel.dialog.setParams(params);
      VoluntaryMedicalInsuranceFormModel.dialog.show();
      break;
  }
}
