import { createNotifier } from '@client/shared/libs/notifications';

import { MAX_FILE_SIZE_MB } from './constants';

const notifier = createNotifier();

export const DocumentNotifier = {
  documentAdded: notifier.success.prepend((name: string) => {
    return `Вы добавили ${name}`;
  }),
  notFound: notifier.error.prepend(() => {
    return 'Такого адреса не существует';
  }),
  cannotEdit: notifier.error.prepend(() => {
    return 'Этот документ нельзя редактировать';
  }),
  internal: notifier.error.prepend(() => {
    return 'Что-то пошло не так, попробуйте ещё раз позже';
  }),
  maxFileSize: notifier.error.prepend(() => {
    return `Файл слишком большой. Загрузите фото весом до ${MAX_FILE_SIZE_MB} Мб`;
  }),
};
