import { VFC } from 'react';

import { logProps } from '@client/shared/libs/metrika';
import { Carousel, CarouselItem, Text } from '@client/shared/ui-kit';

import { Tile } from '../tile';
import { frequentlyTypeList } from './constants';

import styles from './AddDocumentsFrequently.module.css';

export interface AddDocumentsFrequentlyProps {
  onTilePress?: () => void;
}

export const AddDocumentsFrequently: VFC<AddDocumentsFrequentlyProps> = (props) => {
  const carouselItems = frequentlyTypeList.map((item, index) => {
    return (
      <CarouselItem key={index}>
        <Tile
          type={item.key}
          onPress={() => {
            props.onTilePress && props.onTilePress();
            item.onPress();
          }}
          {...logProps('documents.frequently-used', { documentId: item.key })}
        />
      </CarouselItem>
    );
  });

  return (
    <div className={styles.root}>
      <Text variant="heading-m" as="h3">
        Нужны чаще всего
      </Text>
      <Carousel>{carouselItems}</Carousel>
    </div>
  );
};
