import cx from 'classnames';
import { VFC } from 'react';

import { List, ListItemAction, Section } from '@client/shared/ui-kit';

import { DocumentsListData } from './constants';

import styles from './AddDocumentsList.module.css';

export interface AddDocumentsListProps {
  onItemPress?: () => void;
}

export const AddDocumentsList: VFC<AddDocumentsListProps> = (props) => (
  <div className={styles.root}>
    {DocumentsListData.map((section) => (
      <Section
        key={section.key}
        className={cx(styles.section, {
          [styles.section_red]: section.color === 'red-gradient100',
          [styles.section_green]: section.color === 'green-gradient100',
          [styles.section_blue]: section.color === 'blue-gradient100',
          [styles.section_violet]: section.color === 'violet-gradient100',
        })}
      >
        <Section.Title>{section.title}</Section.Title>
        <List>
          {section.documents.map((document) => (
            <ListItemAction
              plateColor={section.color}
              key={document.key}
              type="add"
              text={document.text}
              icon={document.icon}
              onPress={() => {
                props.onItemPress && props.onItemPress();
                document.onPress();
              }}
            />
          ))}
        </List>
      </Section>
    ))}
  </div>
);
