import { PlateColor } from '@client/shared/ui-kit';

import { BaseDocumentList } from '../../libs/base-list';

export const DocumentsListData = [
  {
    key: 'personal',
    title: 'Личные документы',
    color: 'red-gradient100' as PlateColor,
    documents: [
      BaseDocumentList.NATIONAL_ID,
      BaseDocumentList.INTERNATIONAL_ID,
      BaseDocumentList.BIRTH_CERTIFICATE,
    ],
  },
  {
    key: 'transport',
    title: 'Транспорт',
    color: 'violet-gradient100' as PlateColor,
    documents: [BaseDocumentList.DRIVER_LICENSE, BaseDocumentList.VEHICLE_REGISTRATION_CERTIFICATE],
  },
  {
    key: 'health',
    title: 'Здоровье',
    color: 'blue-gradient100' as PlateColor,
    documents: [BaseDocumentList.MEDICAL_INSURANCE, BaseDocumentList.VOLUNTARY_MEDICAL_INSURANCE],
  },
  {
    key: 'finance',
    title: 'Финансы',
    color: 'green-gradient100' as PlateColor,
    documents: [BaseDocumentList.INN, BaseDocumentList.SNILS],
  },
];
