import { VFC } from 'react';

import {
  DocumentForm,
  MultiFieldSkeleton,
  TextFieldSkeleton,
} from '@client/entities/document-form';
import { DocumentImageListSkeleton } from '@client/entities/document-image-list';

const noop = () => null;

export const BirthCertificateFormSkeleton: VFC = () => {
  return (
    <DocumentForm isVisible isDisabled onClose={noop} onSubmit={noop}>
      <DocumentForm.Title text="Св-во о рождении" />
      <DocumentForm.Preview>
        <DocumentImageListSkeleton size="s" />
      </DocumentForm.Preview>
      <DocumentForm.Section>
        <MultiFieldSkeleton count={2} />
        <MultiFieldSkeleton count={3} />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
      </DocumentForm.Section>
      <DocumentForm.Section>
        <MultiFieldSkeleton count={3} />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
      </DocumentForm.Section>
      <DocumentForm.Section>
        <MultiFieldSkeleton count={3} />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
      </DocumentForm.Section>
      <DocumentForm.Section>
        <TextFieldSkeleton />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
      </DocumentForm.Section>
    </DocumentForm>
  );
};
