import { attach, createEvent, sample } from 'effector';

import { BirthCertificateDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';
import * as viewerModel from './viewer-model';

export const dialog = createDialogApi();

export const deleteDocumentClicked = createEvent();
export const confirmDeleteDocumentClicked = createEvent();
export const abortDeleteDocumentClicked = createEvent();

const deleteBirthCertificateFx = attach({
  effect: api.deleteBirthCertificateFx,
});

export const $isBirthCertificateDeleting = deleteBirthCertificateFx.pending;

sample({
  clock: deleteDocumentClicked,
  target: dialog.show,
});

sample({
  clock: abortDeleteDocumentClicked,
  target: dialog.hide,
});

sample({
  clock: confirmDeleteDocumentClicked,
  source: viewerModel.$document,
  filter(document): document is BirthCertificateDocument {
    return document !== null;
  },
  fn: (document: BirthCertificateDocument) => ({ id: document.id }),
  target: deleteBirthCertificateFx,
});

sample({
  clock: deleteBirthCertificateFx.doneData,
  target: [dialog.hide, viewerModel.dialog.hide],
});

sample({
  clock: deleteBirthCertificateFx.failData,
  target: [dialog.hide, viewerModel.dialog.hide, DocumentNotifier.internal],
});
