import { BlankFieldData } from '@client/entities/document-viewer';
import { BirthCertificateDocument } from '@client/shared/api/graphql';

import { FieldType } from '../interface';

export interface GetBlankFieldsParams {
  document: BirthCertificateDocument;
  generateOnPress: (type: FieldType) => () => void;
}

export function getBlankFields(params: GetBlankFieldsParams) {
  const { document, generateOnPress } = params;
  const blankFields: BlankFieldData[] = [];

  if (!document.series) {
    blankFields.push({
      text: 'Серия',
      onPress: generateOnPress('series'),
    });
  }

  if (!document.docNumber) {
    blankFields.push({
      text: 'Номер',
      onPress: generateOnPress('docNumber'),
    });
  }

  if (!document.lastName) {
    blankFields.push({
      text: 'Фамилия',
      onPress: generateOnPress('lastName'),
    });
  }

  if (!document.firstName) {
    blankFields.push({
      text: 'Имя',
      onPress: generateOnPress('firstName'),
    });
  }

  if (!document.middleName) {
    blankFields.push({
      text: 'Отчество',
      onPress: generateOnPress('middleName'),
    });
  }

  if (!document.birthDate) {
    blankFields.push({
      text: 'Дата рождения',
      onPress: generateOnPress('birthDate'),
    });
  }

  if (!document.birthPlace) {
    blankFields.push({
      text: 'Место рождения',
      onPress: generateOnPress('birthPlace'),
    });
  }

  if (!document.birthAkt) {
    blankFields.push({
      text: 'Номер записи акта о рождении',
      onPress: generateOnPress('birthAkt'),
    });
  }

  if (!document.fatherLastName) {
    blankFields.push({
      text: 'Фамилия отца',
      onPress: generateOnPress('fatherLastName'),
    });
  }
  if (!document.fatherFirstName) {
    blankFields.push({
      text: 'Имя отца',
      onPress: generateOnPress('fatherFirstName'),
    });
  }
  if (!document.fatherMiddleName) {
    blankFields.push({
      text: 'Отчество отца',
      onPress: generateOnPress('fatherMiddleName'),
    });
  }
  if (!document.fatherCitizenship) {
    blankFields.push({
      text: 'Гражданство отца',
      onPress: generateOnPress('fatherCitizenship'),
    });
  }
  if (!document.fatherBirthDate) {
    blankFields.push({
      text: 'Дата рождения отца',
      onPress: generateOnPress('fatherBirthDate'),
    });
  }
  if (!document.fatherNationality) {
    blankFields.push({
      text: 'Национальность отца',
      onPress: generateOnPress('fatherNationality'),
    });
  }

  if (!document.motherLastName) {
    blankFields.push({
      text: 'Фамилия матери',
      onPress: generateOnPress('motherLastName'),
    });
  }
  if (!document.motherFirstName) {
    blankFields.push({
      text: 'Имя матери',
      onPress: generateOnPress('motherFirstName'),
    });
  }
  if (!document.motherMiddleName) {
    blankFields.push({
      text: 'Отчество матери',
      onPress: generateOnPress('motherMiddleName'),
    });
  }
  if (!document.motherCitizenship) {
    blankFields.push({
      text: 'Гражданство матери',
      onPress: generateOnPress('motherCitizenship'),
    });
  }
  if (!document.motherBirthDate) {
    blankFields.push({
      text: 'Дата рождения матери',
      onPress: generateOnPress('motherBirthDate'),
    });
  }
  if (!document.motherNationality) {
    blankFields.push({
      text: 'Национальность матери',
      onPress: generateOnPress('motherNationality'),
    });
  }

  if (!document.registrationPlace) {
    blankFields.push({
      text: 'Место государственной регистрации',
      onPress: generateOnPress('registrationPlace'),
    });
  }
  if (!document.issuePlace) {
    blankFields.push({
      text: 'Место выдачи свидетельства',
      onPress: generateOnPress('issuePlace'),
    });
  }
  if (!document.issueDate) {
    blankFields.push({
      text: 'Дата выдачи',
      onPress: generateOnPress('issueDate'),
    });
  }

  return blankFields;
}
