import { BirthCertificateDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';

interface Field {
  text: string;
  label: string;
}

interface Section {
  fields: Field[];
  name: string;
}

export function splitFieldsIntoSections(document: BirthCertificateDocument) {
  const sections: Section[] = [];

  const fullName = getFullName({
    firstName: document.firstName,
    lastName: document.lastName,
    middleName: document.middleName,
    withPatronymic: true,
  });

  const fatherFullName = getFullName({
    firstName: document.fatherFirstName,
    lastName: document.fatherLastName,
    middleName: document.fatherMiddleName,
    withPatronymic: true,
  });

  const motherFullName = getFullName({
    firstName: document.motherFirstName,
    lastName: document.motherLastName,
    middleName: document.motherMiddleName,
    withPatronymic: true,
  });

  {
    const fields: Field[] = [];

    if (document.series && document.docNumber) {
      fields.push({
        text: document.series + document.docNumber,
        label: 'Серия и номер',
      });
    }

    if (fullName) {
      fields.push({
        text: fullName,
        label: 'ФИО',
      });
    }

    if (document.birthDate) {
      fields.push({
        text: formatDateToNormal(document.birthDate),
        label: 'Дата рождения',
      });
    }

    if (document.birthPlace) {
      fields.push({
        text: document.birthPlace,
        label: 'Место рождения',
      });
    }

    if (document.birthAkt) {
      fields.push({
        text: document.birthAkt,
        label: 'Номер записи акта о рождении',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'first_section',
        fields,
      });
    }
  }

  {
    const fields: Field[] = [];

    if (fatherFullName) {
      fields.push({
        text: fatherFullName,
        label: 'ФИО отца',
      });
    }

    if (document.fatherCitizenship) {
      fields.push({
        text: document.fatherCitizenship,
        label: 'Гражданство отца',
      });
    }

    if (document.fatherBirthDate) {
      fields.push({
        text: formatDateToNormal(document.fatherBirthDate),
        label: 'Дата рождения отца',
      });
    }

    if (document.fatherNationality) {
      fields.push({
        text: document.fatherNationality,
        label: 'Национальность отца',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'second_section',
        fields,
      });
    }
  }

  {
    const fields: Field[] = [];

    if (motherFullName) {
      fields.push({
        text: motherFullName,
        label: 'ФИО матери',
      });
    }

    if (document.motherCitizenship) {
      fields.push({
        text: document.motherCitizenship,
        label: 'Гражданство матери',
      });
    }

    if (document.motherBirthDate) {
      fields.push({
        text: formatDateToNormal(document.motherBirthDate),
        label: 'Дата рождения матери',
      });
    }

    if (document.motherNationality) {
      fields.push({
        text: document.motherNationality,
        label: 'Национальность матери',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'third_section',
        fields,
      });
    }
  }

  {
    const fields: Field[] = [];

    if (document.registrationPlace) {
      fields.push({
        text: document.registrationPlace,
        label: 'Место государственной регистрации',
      });
    }

    if (document.issuePlace) {
      fields.push({
        text: document.issuePlace,
        label: 'Место выдачи свидетельства',
      });
    }

    if (document.issueDate) {
      fields.push({
        text: formatDateToNormal(document.issueDate),
        label: 'Дата выдачи',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'fourth_section',
        fields,
      });
    }
  }

  return sections;
}
