import { BirthCertificateDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';
import { Field } from '../types/field';

export const getFields = (doc: BirthCertificateDocument) => {
  const fields: Field[] = [];

  const fullName = getFullName({
    firstName: doc.firstName,
    lastName: doc.lastName,
    withPatronymic: false,
  });
  const fatherFullName = getFullName({
    firstName: doc.fatherFirstName,
    lastName: doc.fatherLastName,
    middleName: doc.fatherMiddleName,
    withPatronymic: true,
  });
  const motherFullName = getFullName({
    firstName: doc.motherFirstName,
    lastName: doc.motherLastName,
    middleName: doc.motherMiddleName,
    withPatronymic: true,
  });

  if (doc.docNumber && doc.series) {
    fields.push({
      text: doc.series + doc.docNumber,
      label: 'Серия и номер',
    });
  }
  if (fullName) {
    fields.push({
      text: fullName,
      label: 'ФИО',
    });
  }
  if (doc.birthDate) {
    fields.push({
      text: formatDateToNormal(doc.birthDate),
      label: 'Дата рождения',
    });
  }
  if (doc.birthPlace) {
    fields.push({
      text: doc.birthPlace,
      label: 'Место рождения',
    });
  }
  if (doc.birthAkt) {
    fields.push({
      text: doc.birthAkt,
      label: 'Номер записи акта о рождении',
    });
  }
  if (fatherFullName) {
    fields.push({
      text: fatherFullName,
      label: 'ФИО отца',
    });
  }
  if (doc.fatherCitizenship) {
    fields.push({
      text: doc.fatherCitizenship,
      label: 'Гражданство отца',
    });
  }
  if (doc.fatherBirthDate) {
    fields.push({
      text: formatDateToNormal(doc.fatherBirthDate),
      label: 'Дата рождения отца',
    });
  }
  if (doc.fatherNationality) {
    fields.push({
      text: doc.fatherNationality,
      label: 'Национальность отца',
    });
  }
  if (motherFullName) {
    fields.push({
      text: motherFullName,
      label: 'ФИО матери',
    });
  }
  if (doc.motherCitizenship) {
    fields.push({
      text: doc.motherCitizenship,
      label: 'Гражданство матери',
    });
  }
  if (doc.motherBirthDate) {
    fields.push({
      text: formatDateToNormal(doc.motherBirthDate),
      label: 'Дата рождения матери',
    });
  }
  if (doc.motherNationality) {
    fields.push({
      text: doc.motherNationality,
      label: 'Национальность матери',
    });
  }
  if (doc.registrationPlace) {
    fields.push({
      text: doc.registrationPlace,
      label: 'Место государственной регистрации',
    });
  }
  if (doc.issuePlace) {
    fields.push({
      text: doc.issuePlace,
      label: 'Место выдачи свидетельства',
    });
  }
  if (doc.issueDate) {
    fields.push({
      text: formatDateToNormal(doc.issueDate),
      label: 'Дата выдачи',
    });
  }

  return fields;
};
