import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { BirthCertificateDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('birth-certificate-viewer');

export const $document = createStore<BirthCertificateDocument | null>(null);

const getBirthCertificateDataFx = attach({
  effect: api.getBirthCertificateDataFx,
});

export const $isLoading = getBirthCertificateDataFx.pending;

$document.on(getBirthCertificateDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getBirthCertificateDataFx,
});

sample({
  clock: getBirthCertificateDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
