import { VFC } from 'react';

import {
  DocumentForm,
  MultiFieldSkeleton,
  TextFieldSkeleton,
} from '@client/entities/document-form';
import { DocumentImageListSkeleton } from '@client/entities/document-image-list';

const noop = () => null;

export const DriverLicenseFormSkeleton: VFC = () => {
  return (
    <DocumentForm isVisible isDisabled onClose={noop} onSubmit={noop}>
      <DocumentForm.Title text="ВУ" />
      <DocumentForm.Preview>
        <DocumentImageListSkeleton size="s" />
      </DocumentForm.Preview>
      <DocumentForm.Section>
        <MultiFieldSkeleton count={2} />
        <MultiFieldSkeleton count={2} />
        <MultiFieldSkeleton count={2} />
        <TextFieldSkeleton />
        <MultiFieldSkeleton count={2} />
      </DocumentForm.Section>
      <DocumentForm.Section>
        <TextFieldSkeleton />
        <TextFieldSkeleton />
        <MultiFieldSkeleton count={2} />
        <TextFieldSkeleton />
        <MultiFieldSkeleton count={2} />
      </DocumentForm.Section>
      <DocumentForm.Section>
        <TextFieldSkeleton />
        <TextFieldSkeleton />
      </DocumentForm.Section>
    </DocumentForm>
  );
};
