import { attach, createEvent, sample } from 'effector';

import { DriverLicenseDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';
import * as viewerModel from './viewer-model';

export const dialog = createDialogApi();

export const deleteDocumentClicked = createEvent();
export const confirmDeleteDocumentClicked = createEvent();
export const abortDeleteDocumentClicked = createEvent();

const deleteDriverLicenseFx = attach({
  effect: api.deleteDriverLicenseFx,
});

export const $isDriverLicenseDeleting = deleteDriverLicenseFx.pending;

sample({
  clock: deleteDocumentClicked,
  target: dialog.show,
});

sample({
  clock: abortDeleteDocumentClicked,
  target: dialog.hide,
});

sample({
  clock: confirmDeleteDocumentClicked,
  source: viewerModel.$document,
  filter(document): document is DriverLicenseDocument {
    return document !== null;
  },
  fn: (document: DriverLicenseDocument) => ({ id: document.id }),
  target: deleteDriverLicenseFx,
});

sample({
  clock: deleteDriverLicenseFx.doneData,
  target: [dialog.hide, viewerModel.dialog.hide],
});

sample({
  clock: deleteDriverLicenseFx.failData,
  target: [dialog.hide, viewerModel.dialog.hide, DocumentNotifier.internal],
});
