import { BlankFieldData } from '@client/entities/document-viewer';
import { DriverLicenseDocument } from '@client/shared/api/graphql';

import { FieldType } from '../interface';

export interface GetBlankFieldsParams {
  document: DriverLicenseDocument;
  generateOnPress: (type: FieldType) => () => void;
}

export function getBlankFields(params: GetBlankFieldsParams) {
  const { document, generateOnPress } = params;
  const blankFields: BlankFieldData[] = [];

  if (!document.docNumber) {
    blankFields.push({
      text: 'Номер',
      onPress: generateOnPress('docNumber'),
    });
  }

  if (!document.lastName) {
    blankFields.push({
      text: 'Фамилия',
      onPress: generateOnPress('lastName'),
    });
  }

  if (!document.firstName) {
    blankFields.push({
      text: 'Имя',
      onPress: generateOnPress('firstName'),
    });
  }

  if (!document.middleName) {
    blankFields.push({
      text: 'Отчество',
      onPress: generateOnPress('middleName'),
    });
  }

  if (!document.birthDate) {
    blankFields.push({
      text: 'Дата рождения',
      onPress: generateOnPress('birthDate'),
    });
  }

  if (!document.birthPlace && !document.birthPlaceLat) {
    blankFields.push({
      text: 'Место рождения',
      onPress: generateOnPress('birthPlace'),
    });
  }

  if (!document.issueDate) {
    blankFields.push({
      text: 'Дата выдачи',
      onPress: generateOnPress('issueDate'),
    });
  }

  if (!document.endDate) {
    blankFields.push({
      text: 'Действует до',
      onPress: generateOnPress('endDate'),
    });
  }

  if (!document.issuedBy && !document.issuedByLat) {
    blankFields.push({
      text: 'Кем выдано',
      onPress: generateOnPress('issuedBy'),
    });
  }

  if (!document.issuedCity && !document.issuedCityLat) {
    blankFields.push({
      text: 'Место выдачи',
      onPress: generateOnPress('issuedCity'),
    });
  }

  if (!document.category) {
    blankFields.push({
      text: 'Категории',
      onPress: generateOnPress('category'),
    });
  }

  if (!document.additionalInformation) {
    blankFields.push({
      text: 'Особые отметки',
      onPress: generateOnPress('additionalInformation'),
    });
  }

  return blankFields;
}
