import { DriverLicenseDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';

interface Field {
  text: string;
  label: string;
}

interface Section {
  fields: Field[];
  name: string;
}

export function splitFieldsIntoSections(document: DriverLicenseDocument) {
  const sections: Section[] = [];

  const fullName = getFullName({
    firstName: document.firstName,
    lastName: document.lastName,
    middleName: document.middleName,
    withPatronymic: true,
  });

  const fullNameLat = getFullName({
    firstName: document.firstNameLat,
    lastName: document.lastNameLat,
    middleName: document.middleNameLat,
    withPatronymic: true,
  });

  {
    const fields: Field[] = [];

    if (document.docNumber) {
      fields.push({
        text: document.docNumber,
        label: 'Номер',
      });
    }

    if (fullName) {
      fields.push({
        text: fullName,
        label: 'ФИО',
      });
    }

    if (fullNameLat) {
      fields.push({
        text: fullNameLat,
        label: 'ФИО латиницей',
      });
    }

    if (document.birthDate) {
      fields.push({
        text: formatDateToNormal(document.birthDate),
        label: 'Дата рождения',
      });
    }

    if (document.birthPlace) {
      fields.push({
        text: document.birthPlace,
        label: 'Место рождения',
      });
    }

    if (document.birthPlaceLat) {
      fields.push({
        text: document.birthPlaceLat,
        label: 'Место рождения латиницей',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'first_section',
        fields,
      });
    }
  }

  {
    const fields: Field[] = [];

    if (document.issueDate) {
      fields.push({
        text: formatDateToNormal(document.issueDate),
        label: 'Дата выдачи',
      });
    }

    if (document.endDate) {
      fields.push({
        text: formatDateToNormal(document.endDate),
        label: 'Действует до',
      });
    }

    if (document.issuedBy) {
      fields.push({
        text: document.issuedBy,
        label: 'Кем выдано',
      });
    }

    if (document.issuedByLat) {
      fields.push({
        text: document.issuedByLat,
        label: 'Кем выдано латиницей',
      });
    }

    if (document.issuedCity) {
      fields.push({
        text: document.issuedCity,
        label: 'Место выдачи',
      });
    }

    if (document.issuedCityLat) {
      fields.push({
        text: document.issuedCityLat,
        label: 'Место выдачи латиницей',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'second_section',
        fields,
      });
    }
  }

  {
    const fields: Field[] = [];

    if (document.category) {
      fields.push({
        text: document.category,
        label: 'Категории',
      });
    }

    if (document.additionalInformation) {
      fields.push({
        text: document.additionalInformation,
        label: 'Особые отметки',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'third_section',
        fields,
      });
    }
  }

  return sections;
}
