import { DriverLicenseDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';
import { Field } from '../types/field';

export const getFields = (doc: DriverLicenseDocument) => {
  const fields: Field[] = [];
  const fullName = getFullName({
    firstName: doc.firstName,
    lastName: doc.lastName,
    middleName: doc.middleName,
    withPatronymic: true,
  });
  const fullNameLat = getFullName({
    firstName: doc.firstNameLat,
    lastName: doc.lastNameLat,
    middleName: doc.middleNameLat,
    withPatronymic: true,
  });

  if (doc.docNumber) {
    fields.push({
      text: doc.docNumber,
      label: 'Номер',
    });
  }
  if (fullName) {
    fields.push({
      text: fullName,
      label: 'ФИО',
    });
  }
  if (fullNameLat) {
    fields.push({
      text: fullNameLat,
      label: 'ФИО латиницей',
    });
  }
  if (doc.birthDate) {
    fields.push({
      text: formatDateToNormal(doc.birthDate),
      label: 'Дата рождения',
    });
  }
  if (doc.birthPlace) {
    fields.push({
      text: doc.birthPlace,
      label: 'Место рождения',
    });
  }
  if (doc.birthPlaceLat) {
    fields.push({
      text: doc.birthPlaceLat,
      label: 'Место рождения латиницей',
    });
  }
  if (doc.issueDate) {
    fields.push({
      text: formatDateToNormal(doc.issueDate),
      label: 'Дата выдачи',
    });
  }
  if (doc.endDate) {
    fields.push({
      text: formatDateToNormal(doc.endDate),
      label: 'Действует до',
    });
  }
  if (doc.issuedBy) {
    fields.push({
      text: doc.issuedBy,
      label: 'Кем выдано',
    });
  }
  if (doc.issuedByLat) {
    fields.push({
      text: doc.issuedByLat,
      label: 'Кем выдано латиницей',
    });
  }
  if (doc.issuedCity) {
    fields.push({
      text: doc.issuedCity,
      label: 'Место выдачи',
    });
  }
  if (doc.issuedCityLat) {
    fields.push({
      text: doc.issuedCityLat,
      label: 'Место выдачи латиницей',
    });
  }
  if (doc.category) {
    fields.push({
      text: doc.category,
      label: 'Категории',
    });
  }
  if (doc.additionalInformation) {
    fields.push({
      text: doc.additionalInformation,
      label: 'Особые отметки',
    });
  }

  return fields;
};
