import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { DriverLicenseDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('driver-license-viewer');

export const $document = createStore<DriverLicenseDocument | null>(null);

const getDriverLicenseDataFx = attach({
  effect: api.getDriverLicenseDataFx,
});

export const $isLoading = getDriverLicenseDataFx.pending;

$document.on(getDriverLicenseDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getDriverLicenseDataFx,
});

sample({
  clock: getDriverLicenseDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
