import { VFC } from 'react';

import {
  DocumentForm,
  MultiFieldSkeleton,
  TextFieldSkeleton,
} from '@client/entities/document-form';
import { DocumentImageListSkeleton } from '@client/entities/document-image-list';

const noop = () => null;

export const InnFormSkeleton: VFC = () => {
  return (
    <DocumentForm isVisible isDisabled onClose={noop} onSubmit={noop}>
      <DocumentForm.Title text="ИНН" />
      <DocumentForm.Preview>
        <DocumentImageListSkeleton size="s" />
      </DocumentForm.Preview>
      <DocumentForm.Section>
        <TextFieldSkeleton />
        <MultiFieldSkeleton count={3} />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
      </DocumentForm.Section>
      <DocumentForm.Section>
        <TextFieldSkeleton />
        <TextFieldSkeleton />
      </DocumentForm.Section>
    </DocumentForm>
  );
};
