import { DocumentGender, InnDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';

interface Field {
  text: string;
  label: string;
}

interface Section {
  fields: Field[];
  name: string;
}

export function splitFieldsIntoSections(document: InnDocument) {
  const sections: Section[] = [];

  const fullName = getFullName({
    firstName: document.firstName,
    lastName: document.lastName,
    middleName: document.middleName,
    withPatronymic: true,
  });

  {
    const fields: Field[] = [];

    if (document.docNumber) {
      fields.push({
        text: document.docNumber,
        label: 'ИНН',
      });
    }

    if (fullName) {
      fields.push({
        text: fullName,
        label: 'ФИО',
      });
    }

    if (document.birthDate) {
      fields.push({
        text: formatDateToNormal(document.birthDate),
        label: 'Дата рождения',
      });
    }

    if (document.gender) {
      fields.push({
        text: document.gender === DocumentGender.Female ? 'Женский' : 'Мужской',
        label: 'Пол',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'first_section',
        fields,
      });
    }
  }

  {
    const fields: Field[] = [];

    if (document.issuedBy) {
      fields.push({
        text: document.issuedBy,
        label: 'Орган, выдавший документ',
      });
    }

    if (document.issueDate) {
      fields.push({
        text: formatDateToNormal(document.issueDate),
        label: 'Дата выдачи',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'second_section',
        fields,
      });
    }
  }

  return sections;
}
