import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { InnDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('inn-viewer');

export const $document = createStore<InnDocument | null>(null);

const getInnDataFx = attach({
  effect: api.getInnDataFx,
});

export const $isLoading = getInnDataFx.pending;

$document.on(getInnDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getInnDataFx,
});

sample({
  clock: getInnDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
