import { VFC, useCallback } from 'react';

import { DocumentThumb } from '@client/entities/document-thumb';
import { PlaneIcon } from '@client/shared/icons';

import { getFullName } from '../../libs/full-name';
import * as model from './viewer-model';

interface InternationalIdThumbProps {
  documentId: string;
  firstName?: string | null;
  lastName?: string | null;
}

export const InternationalIdThumb: VFC<InternationalIdThumbProps> = (props) => {
  const { documentId, firstName, lastName } = props;

  const handleOnDocumentPress = useCallback(() => {
    model.dialog.setParams({ id: documentId });
    model.dialog.show();
  }, [documentId]);

  // должны показывать Имя + Фамилия,
  // новую функцию не хочется писать,
  // поэтому такой "костыль"
  const fullName = getFullName({
    firstName: lastName,
    lastName: firstName,
    withPatronymic: false,
  });

  return (
    <DocumentThumb onPress={handleOnDocumentPress} color="red" icon={<PlaneIcon />}>
      <DocumentThumb.Label>Загранпаспорт</DocumentThumb.Label>
      <DocumentThumb.Description error={!fullName}>
        {fullName || 'Нет ФИО'}
      </DocumentThumb.Description>
    </DocumentThumb>
  );
};
