import { BlankFieldData } from '@client/entities/document-viewer';
import { InternationalIdDocument } from '@client/shared/api/graphql';

import { FieldType } from '../interface';

export interface GetBlankFieldsParams {
  document: InternationalIdDocument;
  generateOnPress: (type: FieldType) => () => void;
}

export function getBlankFields(params: GetBlankFieldsParams) {
  const { document, generateOnPress } = params;
  const blankFields: BlankFieldData[] = [];

  if (!document.docNumber) {
    blankFields.push({
      text: 'Номер',
      onPress: generateOnPress('docNumber'),
    });
  }

  if (!document.lastName) {
    blankFields.push({
      text: 'Фамилия',
      onPress: generateOnPress('lastName'),
    });
  }

  if (!document.firstName) {
    blankFields.push({
      text: 'Имя',
      onPress: generateOnPress('firstName'),
    });
  }

  if (!document.citizenship && !document.citizenshipLat) {
    blankFields.push({
      text: 'Гражданство',
      onPress: generateOnPress('citizenship'),
    });
  }

  if (!document.birthDate) {
    blankFields.push({
      text: 'Дата рождения',
      onPress: generateOnPress('birthDate'),
    });
  }

  if (!document.gender) {
    blankFields.push({
      text: 'Пол',
      onPress: generateOnPress('gender'),
    });
  }

  if (!document.birthPlace && !document.birthPlaceLat) {
    blankFields.push({
      text: 'Место рождения',
      onPress: generateOnPress('birthPlace'),
    });
  }

  if (!document.issueDate) {
    blankFields.push({
      text: 'Дата выдачи',
      onPress: generateOnPress('issueDate'),
    });
  }

  if (!document.endDate) {
    blankFields.push({
      text: 'Дата окончания срока',
      onPress: generateOnPress('endDate'),
    });
  }

  if (!document.issuedBy) {
    blankFields.push({
      text: 'Кем выдан',
      onPress: generateOnPress('issuedBy'),
    });
  }

  return blankFields;
}
