import { DocumentGender, InternationalIdDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';

interface Field {
  text: string;
  label: string;
}

interface Section {
  fields: Field[];
  name: string;
}

export function splitFieldsIntoSections(document: InternationalIdDocument) {
  const sections: Section[] = [];

  const fullName = getFullName({
    firstName: document.firstName,
    lastName: document.lastName,
    withPatronymic: false,
  });

  const fullNameLat = getFullName({
    firstName: document.firstNameLat,
    lastName: document.lastNameLat,
    withPatronymic: false,
  });

  {
    const fields: Field[] = [];

    if (document.docNumber) {
      fields.push({
        text: document.docNumber,
        label: 'Номер',
      });
    }

    if (fullName) {
      fields.push({
        text: fullName,
        label: 'ФИО',
      });
    }

    if (fullNameLat) {
      fields.push({
        text: fullNameLat,
        label: 'Имя и фамилия латиницей',
      });
    }

    if (document.citizenship) {
      fields.push({
        text: document.citizenship,
        label: 'Гражданство',
      });
    }

    if (document.citizenshipLat) {
      fields.push({
        text: document.citizenshipLat,
        label: 'Гражданство латиницей',
      });
    }

    if (document.birthDate) {
      fields.push({
        text: formatDateToNormal(document.birthDate),
        label: 'Дата рождения',
      });
    }

    if (document.gender) {
      fields.push({
        text: document.gender === DocumentGender.Female ? 'Женский' : 'Мужской',
        label: 'Пол',
      });
    }

    if (document.birthPlace) {
      fields.push({
        text: document.birthPlace,
        label: 'Место рождения',
      });
    }

    if (document.birthPlaceLat) {
      fields.push({
        text: document.birthPlaceLat,
        label: 'Место рождения латиницей',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'first_section',
        fields,
      });
    }
  }

  {
    const fields: Field[] = [];

    if (document.issueDate) {
      fields.push({
        text: formatDateToNormal(document.issueDate),
        label: 'Дата выдачи',
      });
    }

    if (document.endDate) {
      fields.push({
        text: formatDateToNormal(document.endDate),
        label: 'Дата окончания срока',
      });
    }

    if (document.issuedBy) {
      fields.push({
        text: document.issuedBy,
        label: 'Кем выдан',
      });
    }

    if (fields.length > 0) {
      sections.push({
        name: 'second_section',
        fields,
      });
    }
  }

  return sections;
}
