import { InternationalIdDocument } from '@client/shared/api/graphql';

import { formatDateToNormal } from '../../../libs/date';
import { getFullName } from '../../../libs/full-name';
import { Field } from '../types/field';

export const getFields = (doc: InternationalIdDocument) => {
  const fields: Field[] = [];
  const gendersMap = {
    MALE: 'Мужской',
    FEMALE: 'Женский',
  };
  const fullName = getFullName({
    firstName: doc.firstName,
    lastName: doc.lastName,
    withPatronymic: false,
  });
  const fullNameLat = getFullName({
    firstName: doc.firstNameLat,
    lastName: doc.lastNameLat,
    withPatronymic: false,
  });

  if (doc.docNumber) {
    fields.push({
      text: doc.docNumber,
      label: 'Номер',
    });
  }
  if (fullName) {
    fields.push({
      text: fullName,
      label: 'ФИО',
    });
  }
  if (fullNameLat) {
    fields.push({
      text: fullNameLat,
      label: 'Имя и фамилия латиницей',
    });
  }
  if (doc.birthDate) {
    fields.push({
      text: formatDateToNormal(doc.birthDate),
      label: 'Дата рождения',
    });
  }
  if (doc.gender) {
    fields.push({
      text: gendersMap[doc.gender],
      label: 'Пол',
    });
  }
  if (doc.birthPlace) {
    fields.push({
      text: doc.birthPlace,
      label: 'Место рождения',
    });
  }
  if (doc.birthPlaceLat) {
    fields.push({
      text: doc.birthPlaceLat,
      label: 'Место рождения латиницей',
    });
  }
  if (doc.issueDate) {
    fields.push({
      text: formatDateToNormal(doc.issueDate),
      label: 'Дата выдачи',
    });
  }
  if (doc.endDate) {
    fields.push({
      text: formatDateToNormal(doc.endDate),
      label: 'Дата окончания срока',
    });
  }
  if (doc.issuedBy) {
    fields.push({
      text: formatDateToNormal(doc.issuedBy),
      label: 'Кем выдан',
    });
  }

  return fields;
};
