import { attach, createStore, sample } from 'effector';
import { createGate } from 'effector-react';

import { InternationalIdDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';

interface DocumentId {
  id: string;
}

export const DocumentIdGate = createGate<DocumentId>();
export const dialog = createDialogApi('international-id-viewer');

export const $document = createStore<InternationalIdDocument | null>(null);

const getInternationalIdDataFx = attach({
  effect: api.getInternationalIdDataFx,
});

export const $isLoading = getInternationalIdDataFx.pending;

$document.on(getInternationalIdDataFx.doneData, (_, document) => document);

// get init data
sample({
  clock: DocumentIdGate.state,
  filter: (state) => Boolean(state.id),
  target: getInternationalIdDataFx,
});

sample({
  clock: getInternationalIdDataFx.failData,
  target: [dialog.hide, DocumentNotifier.notFound],
});
