import { VFC } from 'react';

import {
  DocumentForm,
  MultiFieldSkeleton,
  TextFieldSkeleton,
} from '@client/entities/document-form';
import { DocumentImageListSkeleton } from '@client/entities/document-image-list';

const noop = () => null;

export const MedicalInsuranceFormSkeleton: VFC = () => {
  return (
    <DocumentForm isVisible isDisabled onClose={noop} onSubmit={noop}>
      <DocumentForm.Title text="ОМС" />
      <DocumentForm.Preview>
        <DocumentImageListSkeleton size="s" />
      </DocumentForm.Preview>
      <DocumentForm.Section>
        <TextFieldSkeleton />
        <MultiFieldSkeleton count={3} />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
        <TextFieldSkeleton />
      </DocumentForm.Section>
    </DocumentForm>
  );
};
