import { attach, createEvent, sample } from 'effector';

import { MedicalInsuranceDocument } from '@client/shared/api/graphql';
import { createDialogApi } from '@client/shared/libs/effector-helpers';

import { DocumentNotifier } from '../../notitier';
import * as api from './api';
import * as viewerModel from './viewer-model';

export const dialog = createDialogApi();

export const deleteDocumentClicked = createEvent();
export const confirmDeleteDocumentClicked = createEvent();
export const abortDeleteDocumentClicked = createEvent();

const deleteMedicalInsuranceFx = attach({
  effect: api.deleteMedicalInsuranceFx,
});

export const $isMedicalInsuranceDeleting = deleteMedicalInsuranceFx.pending;

sample({
  clock: deleteDocumentClicked,
  target: dialog.show,
});

sample({
  clock: abortDeleteDocumentClicked,
  target: dialog.hide,
});

sample({
  clock: confirmDeleteDocumentClicked,
  source: viewerModel.$document,
  filter(document): document is MedicalInsuranceDocument {
    return document !== null;
  },
  fn: (document: MedicalInsuranceDocument) => ({ id: document.id }),
  target: deleteMedicalInsuranceFx,
});

sample({
  clock: deleteMedicalInsuranceFx.doneData,
  target: [dialog.hide, viewerModel.dialog.hide],
});

sample({
  clock: deleteMedicalInsuranceFx.failData,
  target: [dialog.hide, viewerModel.dialog.hide, DocumentNotifier.internal],
});
